//Created: May 11, 2007
//Revised: September 18, 2008

#include <stdlib.h>
#include <iostream>
#include <string>
#include "Methods.h"
#include "Vector.cpp"

using namespace std;

int main(int argc, char* argv[]) {
	
	char * SETTINGS_FILE = "Duke 3D Mod Manager.ini";
	Vector<Variable> * settings = readVariables(SETTINGS_FILE, "Settings");
	
	char * MOD_DIRECTORY = getVariableValue("Mod Directory", settings);
	Vector<Mod> * mods = readMods(SETTINGS_FILE, "Modifications");
	
	Mod * selection;
	int valid, mod;
	
	do {
		// loop through and display all of the choices passed in
		for(int i=0;i<mods->size();i++) {
			cout << (i+1) << ") " << mods->elementAt(i) << "\n";
		}
		cout << (mods->size()+1) << ") Next";
		
		// print the input prompt message
		cout << "\nChoice: ";
		cout.flush();
		
		// allow the user to enter an integer
		mod = inputInteger();
		
		// verify that the input is within the acceptable range
		valid = mod >= 1 && mod <= mods->size();
		
		// if the input was invalid, display an error message
		if(!valid) {
			cout << "\nERROR: Invalid selection.\n\n";
		}
	} while(!valid);

	selection = &mods->elementAt(mod-1);

	char cmd[COMMAND_LENGTH] = "DUKE3D.EXE";
	char cmd2[COMMAND_LENGTH] = "KEXTRACT.EXE";
	
	// create command to run mod with mod con / group files
	append(cmd, " /g");
	append(cmd, MOD_DIRECTORY);
	append(cmd, selection->group());
	if((int)strlen(selection->con())>0) {
		append(cmd, " /x");
		append(cmd, MOD_DIRECTORY);
		append(cmd, selection->con());
	}
	
	// create command to extract demos from group file
	append(cmd2, " ");
	append(cmd2, MOD_DIRECTORY);
	append(cmd2, selection->group());
	append(cmd2, " *.dmo");
	
	// back up demos in current directory
	system("if exist DEMO1.DMO ren DEMO1.DMO DEMO1.TEMP_DMO");
	system("if exist DEMO2.DMO ren DEMO2.DMO DEMO2.TEMP_DMO");
	system("if exist DEMO3.DMO ren DEMO3.DMO DEMO3.TEMP_DMO");
	
	// extract demos from group file
	system(cmd2);
	
	// run the game with the group + con files linked to it
	system(cmd);
	
	// delete any demos extracted from the group file
	system("if exist *.dmo del *.dmo");
	
	// restore backed up demos to their original file names
	system("if exist DEMO1.TEMP_DMO ren DEMO1.TEMP_DMO DEMO1.DMO");
	system("if exist DEMO2.TEMP_DMO ren DEMO2.TEMP_DMO DEMO2.DMO");
	system("if exist DEMO3.TEMP_DMO ren DEMO3.TEMP_DMO DEMO3.DMO");
	
	return 0;
}